% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_funcs.R
\name{combns}
\alias{combns}
\title{Generate every permutation of n elements.}
\usage{
combns(x, m, FUN = NULL, simplify = TRUE, ...)
}
\arguments{
\item{x}{Vector source for combination.}

\item{m}{Number of elements required. Multiple counts can be supplied.}

\item{FUN}{Function applied to each combination.}

\item{simplify}{Logical indicating if the result should be simplified to an array or returned as a list.}

\item{...}{further arguments passed to FUN. Optional.}
}
\value{
\code{\link{number_line}}.
}
\description{
An extension of \code{\link{combn}} to generate permutations not ordinarily captured by \code{\link{combn}}.
Each argument should be used as would be used in \code{\link{combn}}.
}
\details{
\bold{\code{combns}} - Return every possible permutation of . An extension of \code{combn}.
}
\examples{
f1 <- function(x) paste0(x, collapse = ",")
combn(x = 1:3, m = 3, FUN = f1, simplify = TRUE)
combns(x = 1:3, m = 3, FUN = f1, simplify = TRUE)
combns(x = 1:3, m = 1:3, FUN = f1, simplify = TRUE)

}
