% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{class}
\name{diveModel-class}
\alias{diveModel-class}
\alias{diveModel}
\title{Class "diveModel" for representing a model for identifying dive phases}
\description{
Details of model used to identify the different phases of a dive.
}
\section{Slots}{

\describe{
\item{\code{label.matrix}}{Object of class \code{"matrix"}.  A 2-column
character matrix with row numbers matching each observation to the
full \code{\link{TDR}} object, and a vector labelling the phases of
each dive.}

\item{\code{model}}{Object of class \code{"character"}.  A string identifying
the specific model fit to dives for the purpose of dive phase
identification.  It should be one of \sQuote{smooth.spline} or
\sQuote{unimodal}.}

\item{\code{dive.spline}}{Object of class \code{"smooth.spline"}. Details of
cubic smoothing spline fit (see
\code{\link[stats]{smooth.spline}}).}

\item{\code{spline.deriv}}{Object of class \code{"list"}.  A list with the
first derivative of the smoothing spline (see
\code{\link[stats]{predict.smooth.spline}}).}

\item{\code{descent.crit}}{Object of class \code{"numeric"}.  The index of the
observation at which the descent was deemed to have ended (from
initial surface observation).}

\item{\code{ascent.crit}}{Object of class \code{"numeric"}.  the index of the
observation at which the ascent was deemed to have ended (from
initial surface observation).}

\item{\code{descent.crit.rate}}{Object of class \code{"numeric"}. The rate of
descent corresponding to the critical quantile used.}

\item{\code{ascent.crit.rate}}{Object of class \code{"numeric"}. The rate of
ascent corresponding to the critical quantile used.}
}}

\section{Objects from the Class}{

Objects can be created by calls of the form \code{new("diveModel",
    ...)}.

\sQuote{diveModel} objects contain all relevant details of the process to
identify phases of a dive.  Objects of this class are typically generated
during depth calibration, using \code{\link{calibrateDepth}}, more
specifically \code{\link{.cutDive}}.
}

\examples{
showClass("diveModel")

\donttest{## Too long for checks
## Continuing the Example from '?calibrateDepth':
utils::example("calibrateDepth", package="diveMove",
               ask=FALSE, echo=FALSE, run.donttest=TRUE)
dcalib		# the 'TDRcalibrate' that was created

## Compare dive models for dive phase detection
diveNo <- 255
diveX <- as.data.frame(extractDive(dcalib, diveNo=diveNo))
diveX.m <- cbind(as.numeric(row.names(diveX[-c(1, nrow(diveX)), ])),
                 diveX$depth[-c(1, nrow(diveX))],
                 diveX$time[-c(1, nrow(diveX))])

## calibrateDepth() default unimodal regression. Number of inner knots is
## either 10 or the number of samples in the dive, whichever is larger.
(phases.uni <- diveMove:::.cutDive(diveX.m, smooth.par=0.2, knot.factor=20,
                                   dive.model="unimodal",
                                   descent.crit.q=0.01, ascent.crit.q=0))
## Smoothing spline model, using default smoothing parameter.
(phases.spl <- diveMove:::.cutDive(diveX.m, smooth.par=0.2, knot.factor=20,
                                   dive.model="smooth.spline",
                                   descent.crit.q=0.01, ascent.crit.q=0))
plotDiveModel(phases.spl,
              diveNo=paste(diveNo, ", smooth.par=", 0.2, sep=""))
plotDiveModel(phases.uni, diveNo=paste(diveNo))

}
}
\seealso{
\code{\link{getDiveDeriv}}, \code{\link{plotDiveModel}}
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
\keyword{classes}
