% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use-dittodb.R
\name{use_dittodb}
\alias{use_dittodb}
\title{Use {dittodb} in your tests}
\usage{
use_dittodb(path = ".")
}
\arguments{
\item{path}{character path to the package}
}
\value{
Nothing: called for file system side effects.
}
\description{
If you would like to use {dittodb} in your package, and you are already using
\href{https://CRAN.R-project.org/package=testthat}{{testthat}}, use this function to
add {dittodb} to Suggests in the package DESCRIPTION and loads it in
\code{tests/testthat/helper.R}. Call it once when you're setting up a new package
test suite.
}
\details{
This function should be called with the path to your package source as the
\code{path} argument. The function is idempotent: if {dittodb} is already added to
these files, no additional changes will be made.

It will:
\itemize{
\item add {dittodb} to the \code{Suggests} field of the DESCRIPTION file in the
current working directory
\item add \code{library(dittodb)} to the file \code{tests/testthat/helper.R} (creating it
if it doesn't already exist)
}
}
\examples{
\dontrun{
use_dittodb()
use_dittodb("/path/to/package")
}
}
