% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capture-requests.R
\name{capture_requests}
\alias{capture_requests}
\alias{start_db_capturing}
\alias{stop_db_capturing}
\alias{capture_db_requests}
\title{Capture and record database transactions and save them as mocks}
\usage{
start_db_capturing(path, redact_columns = NULL)

stop_db_capturing()

capture_db_requests(expr, path, redact_columns = NULL)
}
\arguments{
\item{path}{the path to record mocks (default if missing: the first path in
\code{db_mock_paths()}.}

\item{redact_columns}{a character vector of columns to redact. Any column
that matches an entry will be redacted with a standard value for the column
type (e.g. characters will be replaced with "[redacted]")}

\item{expr}{an expression to evaluate while capturing requests (for
\code{capture_db_requests()})}
}
\value{
\code{NULL} (invisibily)
}
\description{
When creating database fixtures, it can sometimes be helpful to record
the responses from the database for use in crafting tests.
}
\details{
You can start capturing with \code{start_db_capturing()} and end it with
\code{stop_db_capturing()}. All queries run against a database will be executed like
normal, but their responses will be saved to the mock path given, so that if
you use the same queries later inside of a \code{\link{with_mock_db}} block, the
database functions will return as if they had been run against the database.

Alternatively, you can wrap the code that you are trying to capture in the
function \code{capture_db_requests({...})} this does the same thing as
\code{start_db_capturing()} and \code{stop_db_capturing()} but without needing to
remember to stop the recording.

You can redact certain columns using the \code{redact_columns} argument. This will
replace the values in the column with a generic redacted version. This works
by always passing the data being saved through \code{\link{redact_columns}}.

\emph{note} You should always call \code{\link[DBI:dbConnect]{DBI::dbConnect}} inside of the capturing
block. When you connect to the database, dittodb sets up the mocks for the
specific database you're connecting to when you call \code{\link[DBI:dbConnect]{DBI::dbConnect}}.
}
\examples{
\donttest{
# Temporary files for examples
nycflights_path <- tempfile()

con <- nycflights13_create_sqlite(location = nycflights_path)
dbDisconnect(con)

start_db_capturing()
con <- dbConnect(RSQLite::SQLite(), nycflights_path)

df_1 <- dbGetQuery(con, "SELECT * FROM airlines LIMIT 1")
res <- dbSendQuery(con, "SELECT * FROM airlines LIMIT 2")
df_2 <- dbFetch(res)
dbClearResult(res)

dbDisconnect(con)
stop_db_capturing()

start_db_capturing(redact_columns = "carrier")
con <- dbConnect(RSQLite::SQLite(), nycflights_path)

df_3 <- dbGetQuery(con, "SELECT * FROM airlines LIMIT 3")

dbDisconnect(con)
stop_db_capturing()

with_mock_db({
  con <- dbConnect(RSQLite::SQLite(), nycflights_path)

  # the result from df1 above
  print(dbGetQuery(con, "SELECT * FROM airlines LIMIT 1"))

  # the result from df3 above
  print(dbGetQuery(con, "SELECT * FROM airlines LIMIT 3"))
})
}
}
