% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonBinomial.R
\name{random.PoissonBinomial}
\alias{random.PoissonBinomial}
\title{Draw a random sample from a PoissonBinomial distribution}
\usage{
\method{random}{PoissonBinomial}(x, n = 1L, drop = TRUE, ...)
}
\arguments{
\item{x}{A \code{PoissonBinomial} object created by a call to \code{\link[=PoissonBinomial]{PoissonBinomial()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
Integers containing values between \code{0} and \code{x$size}.
In case of a single distribution object or \code{n = 1}, either a numeric
vector of length \code{n} (if \code{drop = TRUE}, default) or a \code{matrix} with \code{n} columns
(if \code{drop = FALSE}).
}
\description{
Draw a random sample from a PoissonBinomial distribution
}
\examples{

set.seed(27)

X <- PoissonBinomial(0.5, 0.3, 0.8)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.8)

cdf(X, quantile(X, 0.8))
quantile(X, cdf(X, 2))

## equivalent definitions of four Poisson binomial distributions
## each summing up three Bernoulli probabilities
p <- cbind(
  p1 = c(0.1, 0.2, 0.1, 0.2),
  p2 = c(0.5, 0.5, 0.5, 0.5),
  p3 = c(0.8, 0.7, 0.9, 0.8))
PoissonBinomial(p)
PoissonBinomial(p[, 1], p[, 2], p[, 3])
PoissonBinomial(p[, 1:2], p[, 3])
}
