% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HyperGeometric.R
\name{cdf.HyperGeometric}
\alias{cdf.HyperGeometric}
\title{Evaluate the cumulative distribution function of a HyperGeometric distribution}
\usage{
\method{cdf}{HyperGeometric}(d, x, drop = TRUE, ...)
}
\arguments{
\item{d}{A \code{HyperGeometric} object created by a call to \code{\link[=HyperGeometric]{HyperGeometric()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link[stats]{phyper}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the cumulative distribution function of a HyperGeometric distribution
}
\examples{

set.seed(27)

X <- HyperGeometric(4, 5, 8)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other HyperGeometric distribution: 
\code{\link{pdf.HyperGeometric}()},
\code{\link{quantile.HyperGeometric}()},
\code{\link{random.HyperGeometric}()}
}
\concept{HyperGeometric distribution}
