% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binomial.R
\name{random.Binomial}
\alias{random.Binomial}
\title{Draw a random sample from a Binomial distribution}
\usage{
\method{random}{Binomial}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{Binomial} object created by a call to \code{\link[=Binomial]{Binomial()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector containing values between \code{0} and \code{x$size}
of length \code{n}.
}
\description{
Draw a random sample from a Binomial distribution
}
\examples{

set.seed(27)

X <- Binomial(10, 0.2)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2L)
log_pdf(X, 2L)

cdf(X, 4L)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
