% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NegativeBinomial.R
\name{random.NegativeBinomial}
\alias{random.NegativeBinomial}
\title{Draw a random sample from a negative binomial distribution}
\usage{
\method{random}{NegativeBinomial}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{NegativeBinomial} object created by a call to
\code{\link[=NegativeBinomial]{NegativeBinomial()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of length \code{n}.
}
\description{
Draw a random sample from a negative binomial distribution
}
\examples{

set.seed(27)

X <- NegativeBinomial(10, 0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other NegativeBinomial distribution: \code{\link{cdf.NegativeBinomial}},
  \code{\link{pdf.NegativeBinomial}},
  \code{\link{quantile.NegativeBinomial}}
}
\concept{NegativeBinomial distribution}
