% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometric.R
\name{random.Geometric}
\alias{random.Geometric}
\title{Draw a random sample from a Geometric distribution}
\usage{
\method{random}{Geometric}(d, n = 1L, ...)
}
\arguments{
\item{d}{A \code{Geometric} object created by a call to \code{\link[=Geometric]{Geometric()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
An integer vector of length \code{n}.
}
\description{
Please see the documentation of \code{\link[=Geometric]{Geometric()}} for some properties
of the Geometric distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- Geometric(0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

}
\seealso{
Other Geometric distribution: \code{\link{cdf.Geometric}},
  \code{\link{pdf.Geometric}},
  \code{\link{quantile.Geometric}}
}
\concept{Geometric distribution}
