% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c.Distribution.R
\name{c.Distribution}
\alias{c.Distribution}
\title{Combine Distributions into a VectorDistribution}
\usage{
\method{c}{Distribution}(..., name = NULL, short_name = NULL, description = NULL, decorators = NULL)
}
\arguments{
\item{...}{distributions to be concatenated.}

\item{name, short_name, description, decorators}{See \code{\link{VectorDistribution}}}
}
\value{
A VectorDistribution
}
\description{
Helper function for quickly combining distributions into a \code{\link{VectorDistribution}}.
}
\examples{
# Construct and combine
c(Binomial$new(), Normal$new())

# More complicated distributions
b = truncate(Binomial$new(), 2, 6)
n = huberize(Normal$new(), -1, 1)
c(b, n)

# Concatenate VectorDistributions
v1 = VectorDistribution$new(list(Binomial$new(), Normal$new()))
v2 = VectorDistribution$new(distribution = "Gamma",
             params  = data.table::data.table(shape = 1:2, rate = 1:2))
c(v1, v2)

}
\seealso{
\code{\link{VectorDistribution}}
}
