% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{lines.Distribution}
\alias{lines.Distribution}
\title{Superimpose Distribution Functions Plots for a distr6 Object}
\usage{
\method{lines}{Distribution}(x, fun, npoints = 3000, ...)
}
\arguments{
\item{x}{\code{distr6} object.}

\item{fun}{vector of functions to plot, one or more of: "pdf","cdf","quantile", "survival", "hazard", and "cumhazard"; partial matching available.}

\item{npoints}{number of evaluation points.}

\item{...}{graphical parameters.}
}
\description{
One of six plots can be selected to be superimposed in the plotting window,
including: pdf, cdf, quantile, survival, hazard and cumulative hazard.
}
\details{
Unlike the \code{\link{plot.Distribution}} function, no internal checks are performed
to ensure that the added plot makes sense in the context of the current plotting window. Therefore
this function assumes that the current plot is of the same value support, see examples.
}
\examples{
plot(Normal$new(mean = 2), "pdf")
lines(Normal$new(mean = 3), "pdf", col = "red", lwd = 2)

\dontrun{
# The code below gives examples of how not to use this function.
# Different value supports
plot(Binomial$new(), "cdf")
lines(Normal$new(), "cdf")

# Different functions
plot(Binomial$new(), "pdf")
lines(Binomial$new(), "cdf")

# Too many functions
plot(Binomial$new(), c("pdf","cdf"))
lines(Binomial$new(), "cdf")
}

}
\seealso{
\code{\link{plot.Distribution}} for plotting a \code{distr6} object.
}
\author{
Chengyang Gao, Runlong Yu and Shuhan Liu
}
