% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_ExoticStatistics.R
\name{cdfPNorm}
\alias{cdfPNorm}
\title{Cumulative Distribution Function P-Norm}
\usage{
cdfPNorm(object, p = 2, lower = NULL, upper = NULL)
}
\arguments{
\item{object}{Distribution.}

\item{p}{p-norm to calculate.}

\item{lower}{lower limit for integration, default is infimum.}

\item{upper}{upper limit for integration, default is supremum.}
}
\value{
Given p-norm of cdf evaluated between limits as a numeric.
}
\description{
The p-norm of the cdf evaluated between given limits or over the whole support.
}
\details{
The p-norm of the cdf is defined by
\deqn{(\int_a^b |F_X|^p d\mu)^{1/p}}
where X is the distribution, \eqn{F_X} is the cdf and \eqn{a, b} are the limits of integration.

Returns NULL if distribution is not continuous.

Can only be used after decorating with \code{\link{ExoticStatistics}}.
}
\section{R6 Usage}{
 $cdfPNorm(object, p = 2, lower = NULL, upper = NULL)
}

\seealso{
\code{\link{ExoticStatistics}} and \code{\link{decorate}}
}
