% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTG-probability.R
\name{pFTG}
\alias{pFTG}
\title{FTG Probability Function}
\usage{
pFTG(x, threshold, scale, shape)
}
\arguments{
\item{x}{Sample data.}

\item{threshold}{Minimum value of the tail.}

\item{scale}{Scale parameter.}

\item{shape}{Shape parameter.}
}
\value{
Gives the distribution function of the FTG. The length of the result is determined by the length of x.
}
\description{
This function computes the probability of the full-tail gamma with the input sample data. The expression for the probability used is:
\deqn{G(x; \alpha, \theta, \rho) = 1 - \Gamma(\alpha, \rho + \theta x)/\Gamma(\alpha, \rho).}
}
\examples{
pFTG(1,1,1,1)
}
\references{
del Castillo, Joan & Daoudi, Jalila & Serra, Isabel. (2012). The full-tails gamma distribution applied to model extreme values. ASTIN Bulletin. <doi:10.1017/asb.2017.9>.
}
\keyword{FTG}
