% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/disposable.r
\name{dispose_packages}
\alias{dispose_packages}
\title{Get rid of temporary packages}
\usage{
dispose_packages(packages, unattach = TRUE, unload = unattach,
  delete = TRUE, delete_lib_dir = delete)
}
\arguments{
\item{packages}{A list returned by \code{\link{make_packages}}.}

\item{unattach}{Whether to unattach the packages.}

\item{unload}{Whether to unload the packages. It is not possible to
unload without unattaching.}

\item{delete}{Whether to delete the installed packages from the
\code{lib_dir}. If \code{delete_lib_dir} is \code{TRUE}, then
this should be \code{TRUE} as well.}

\item{delete_lib_dir}{Whether to delete the the whole \code{lib_dir}.}
}
\description{
Get rid of temporary packages
}
\section{Examples}{

\preformatted{
pkg <- make_packages(
  foo1 = { f <- function() print("hello!") ; d <- 1:10 },
  foo2 = { f <- function() print("hello again!") ; d <- 11:20 }
)

foo1::f()
foo2::f()
foo1::d
foo2::d

## Unattach only
dispose_packages(pkg, unload = FALSE, delete = FALSE)
"package:foo1" \%in\% search()
"foo1" \%in\% loadedNamespaces()
dir(pkg$lib_dir)

## Unload
dispose_packages(pkg, delete = FALSE)
"package:foo1" \%in\% search()
"foo1" \%in\% loadedNamespaces()
dir(pkg$lib_dir)

## Delete completely
dispose_packages(pkg)
"package:foo1" \%in\% search()
"foo1" \%in\% loadedNamespaces()
file.exists(pkg$lib_dir)
}
}

