% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseq_deterministic_adjustment.R
\docType{class}
\name{diseq_deterministic_adjustment-class}
\alias{diseq_deterministic_adjustment-class}
\title{Disequilibrium model with deterministic price dynamics.}
\description{
The disequilibrium model with deterministic price adjustment consists of four
equations. The two market equations, the short side rule and  price evolution equation. The first
two equations are stochastic. The price equation is deterministic. The sample is separated
based on the sign of the price changes as in the \code{\linkS4class{diseq_directional}} model.
The model is estimated using full information maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + P_{nt}\alpha_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + P_{nt}\alpha_{s} + u_{s,nt},}
\deqn{Q_{nt} = \min\{D_{nt},S_{nt}\},}
\deqn{\Delta P_{nt} = \frac{1}{\gamma} \left( D_{nt} - S_{nt} \right).}
}
\examples{
simulated_data <- simulate_model_data(
  "diseq_deterministic_adjustment", 500, 3, # model type, observed entities and time points
  -0.9, 8.9, c(0.03, -0.02), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(0.05, 0.02), # supply coefficients
  1.4 # price adjustment coefficient
)

# initialize the model
model <- new(
  "diseq_deterministic_adjustment", # model type
  c("id", "date"), "date", "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  correlated_shocks = TRUE # allow shocks to be correlated
)
}
