% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_helpers.R
\name{age_on_date}
\alias{age_on_date}
\title{Compute the age (in years) on a given date}
\usage{
age_on_date(birth, reference_date, conn)
}
\arguments{
\item{birth}{(\code{character(1)})\cr
Name of the birth date column.}

\item{reference_date}{(\code{Date(1)} or \code{character(1)})\cr
The date to compute the age for (or name of column containing the reference date).}

\item{conn}{(\code{DBIConnection})\cr A database connection.}
}
\value{
SQL query that computes the age on the given date.
}
\description{
Provides the sql code to compute the age of a person on a given date.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
  conn <- SCDB::get_connection(drv = RSQLite::SQLite())

  dplyr::copy_to(conn, data.frame(birth = as.Date("2001-04-03"), "test_age")) |>
    dplyr::mutate(age = !!age_on_date("birth", as.Date("2024-02-28"), conn))

  DBI::dbDisconnect(conn)
\dontshow{\}) # examplesIf}
}
