% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.npdf.R
\name{plot.survfit_npdf}
\alias{plot.survfit_npdf}
\title{Plot Kaplan-Meier estimates of group-specific cumulative hazard from a nonparametric discrete frailty model}
\usage{
\method{plot}{survfit_npdf}(x, xlab = NULL, ylab = NULL, cols = NULL,
  ...)
}
\arguments{
\item{x}{Object returned by \code{\link{survfit_npdf}} representing Kaplan-Meier estimates from a nonparametric discrete frailty model}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{cols}{vector of colour names or numbers, of the same length as the number of groups}

\item{...}{options to pass to the generic \code{plot} function}
}
\description{
Plot Kaplan-Meier estimates of group-specific cumulative hazard from a nonparametric discrete frailty model
}
\examples{
 x = npdf_cox( Surv(time, status) ~ x, groups=family, data=weibdata2030, K = 2,
                estK=FALSE, eps_conv=10^-4)
object = survfit_npdf( x )
plot( object )

}
\seealso{
\code{\link{plot.npdf}}, \code{\link{survfit_npdf}}
}
