% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_AUC.R
\name{prep_log_AUC}
\alias{prep_log_AUC}
\title{Calculate log x_axis values for AUClog}
\usage{
prep_log_AUC(
  dat,
  x_axis,
  log_base = 2,
  type = "adjust",
  correction = 1,
  dec_offset = TRUE
)
}
\arguments{
\item{dat}{Discounting data tibble. \code{AUC_zeroes} should be run first if
zero values on the \code{x_axis} will need to be included.}

\item{x_axis}{Delays/probabilities/social distance variable}

\item{log_base}{Base of the logarithm}

\item{type}{Type of correction to handle 0 values on x_axis. Acceptable values
are "corr"., "adjust", and "IHS". "Corr" adds a set value to each x_axis
value and then takes the log of those values. "Adjust" implements increasing
the x_axis values by the average difference between the log values on the x_axis.
"IHS" calculates the inverse hyperbolic sine, which is different than the logarithm
but is highly correlated with log transformed values. The IHS transformation
does not require corrections}

\item{correction}{If \code{type == "corr"} this value is what is added to the
x_axis prior to taking the log values.}

\item{dec_offset}{If \code{TRUE}, offsets the log x_axis values if the lowest
non-zero x_axis value is a decimal. This calculation is preferred because if
x_axis values are negative then the log values will be negative. The negative
log values can cause inconsistencies in how AUC is calculated.}
}
\value{
Original data frame (a tibble) that includes an appended column with log scale
version of x_axis
}
\description{
Calculate log x_axis values for AUClog
}
\section{Correction types for handling zero x-axis values}{

"Corr" adds a set correction value to each \code{x_axis}
value and then takes the log of those values. "Adjust" implements increasing
the \code{x_axis} values by the average difference between the log values on the \code{x_axis}.
"IHS" calculates the inverse hyperbolic sine for the \code{x_axis},
which is different than the logarithm
but is highly correlated with log transformed values. The IHS transformation
does not require adjustments because \code{IHS(0) == 0}.
}

\examples{

prep_log_AUC(
  dat = examp_DD,
  x_axis = "delay_months",
  log_base = 10,
  dec_offset = TRUE,
  type = "adjust",
  correction = 1
)
}
