% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp-fastcov2.R
\name{fastcov2}
\alias{fastcov2}
\title{Calculate Covariance Matrix in Parallel}
\usage{
fastcov2(x, y = NULL, col1, col2, df)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame; a matrix is highly
recommended to maximize the performance}

\item{y}{NULL (default) or a vector, matrix or data frame with compatible
dimensions to x; the default is equivalent to \code{y = x}}

\item{col1}{integers indicating the subset (columns) of \code{x} to
calculate the covariance; default is all the columns}

\item{col2}{integers indicating the subset (columns) of \code{y} to
calculate the covariance; default is all the columns}

\item{df}{a scalar indicating the degrees of freedom; default is
\code{nrow(x)-1}}
}
\value{
A covariance matrix of \code{x} and \code{y}. Note that there is no
\code{NA} handling. Any missing values will lead to \code{NA} in the
resulting covariance matrices.
}
\description{
Speed up covariance calculation for large matrices. The
default behavior is similar \code{\link{cov}}. Please remove any \code{NA}
prior to calculation.
}
\examples{

# Get numbers of threads to 2
RcppParallel::setThreadOptions(numThreads = 2)

x <- matrix(rnorm(400), nrow = 100)

# Call `cov(x)` to compare
fastcov2(x)

# Calculate covariance of subsets
fastcov2(x, col1 = 1, col2 = 1:2)

# Speed comparison
x <- matrix(rnorm(100000), nrow = 1000)
microbenchmark::microbenchmark(
  fastcov2 = {
    fastcov2(x, col1 = 1:50, col2 = 51:100)
  },
  cov = {
    cov(x[,1:50], x[,51:100])
  },
  unit = 'ms', times = 10
)


}
