% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply.R
\name{iapply}
\alias{iapply}
\title{Apply each elements with index as second input}
\usage{
iapply(X, FUN, ..., .method = c("sapply", "lapply", "vapply"))
}
\arguments{
\item{X}{a vector (atomic or list)}

\item{FUN}{the function to be applied to each element of \code{X}: see `Details`.}

\item{...}{passed to apply methods}

\item{.method}{method to use, default is \code{\link{sapply}}}
}
\value{
a list or matrix depends on \code{.method}. See \code{\link[base]{lapply}}
}
\description{
Apply function with an index variable as the second input.
}
\details{
\code{FUN} will be further passed to the apply methods. Unlike
\code{\link{lapply}}, \code{FUN} is expected to have at least two arguments.
The first argument is each element of \code{X}, the second argument is the
index number of the element.
}
