% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{ask_yesno}
\alias{ask_yesno}
\title{Ask and Return True or False from the Terminal}
\usage{
ask_yesno(..., end = "", level = "INFO", error_if_canceled = TRUE)
}
\arguments{
\item{..., end, level}{passed to \code{\link[dipsaus]{cat2}}}

\item{error_if_canceled}{raise error if canceled.}
}
\value{
logical or \code{NULL} or raise an error. If "yes" is entered,
returns \code{TRUE}; if "no" is entered, returns \code{FALSE}; if "c" is
entered, \code{error_if_canceled=TRUE} will result in an error, otherwise
return \code{NULL}
}
\description{
Ask a question and read from the terminal in interactive scenario
}
\details{
The prompt string will ask for an yes or no question. Users need to
enter "y", "yes" for yes, "n", "no" or no, and "c" for cancel
(case-insensitive).

This can only be used in an \code{\link{interactive}} session.
}
\examples{
if(interactive()){
ask_yesno('Do you know how hard it is to submit an R package and ',
          'pass the CRAN checks?')
ask_yesno('Can I pass the CRAN check this time?')
}
}
\seealso{
\code{\link[dipsaus]{cat2}}, \code{\link[base]{readline}},
\code{\link[dipsaus]{ask_or_default}}
}
