% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_dipm.R
\name{node_dipm}
\alias{node_dipm}
\title{Panel-Generator for Visualization of A Precision Medicine Tree}
\usage{
node_dipm(obj, ...)
}
\arguments{
\item{obj}{A \code{party} tree object returned from either the 
\code{dipm()} or \code{spmtree()} function}

\item{...}{Arguments passed on to plotfun}
}
\value{
No return value, called for plot
}
\description{
This function provides a new plot method for \code{dipm}
 and \code{spmtree}. It visualizes stratified treatment groups through 
 boxplots for a continuous outcome and survival plots for a survival outcome, 
 respectively.
}
\details{
This function visualizes the precision medicine trees
 proposed in Chen and Zhang (2020a, b).
}
\examples{

#' #
# ... an example with a continuous outcome variable
#     and two treatment groups
#

N = 100
set.seed(123)

# generate binary treatments
treatment = rbinom(N, 1, 0.5)

# generate candidate split variables
X1 = rnorm(n = N, mean = 0, sd = 1)
X2 = rnorm(n = N, mean = 0, sd = 1)
X3 = rnorm(n = N, mean = 0, sd = 1)
X4 = rnorm(n = N, mean = 0, sd = 1)
X5 = rnorm(n = N, mean = 0, sd = 1)
X = cbind(X1, X2, X3, X4, X5)
colnames(X) = paste0("X", 1:5)

# generate continuous outcome variable
calculateLink = function(X, treatment){

    ((X[, 1] <= 0) & (X[, 2] <= 0)) *
        (25 * (1 - treatment) + 8 * treatment) + 

    ((X[, 1] <= 0) & (X[, 2] > 0)) *
        (18 * (1 - treatment) + 20 * treatment) +

    ((X[,1 ] > 0) & (X[, 3] <= 0)) *
        (20 * (1 - treatment) + 18 * treatment) + 

    ((X[,1] > 0) & (X[,3] > 0)) *
        (8 * (1 - treatment) + 25 * treatment)
}

Link = calculateLink(X, treatment)
Y = rnorm(N, mean = Link, sd = 1)

# combine variables in a data frame
data = data.frame(X, Y, treatment)

# fit a dipm classification tree
tree = dipm(Y ~ treatment | ., data, mtry = 1, maxdepth = 3) 
plot(tree, terminal_panel = node_dipm)
            

                                    
}
\references{
Chen, V., Li, C., and Zhang, H. (2022). dipm: an 
            R package implementing the Depth Importance in 
            Precision Medicine (DIPM) tree and Forest-based method.
            \emph{Bioinformatics Advances}, \strong{2}(1), vbac041.

            Chen, V. and Zhang, H. (2020). Depth importance in 
            precision medicine (DIPM): a tree and forest based method. 
            In \emph{Contemporary Experimental Design, 
            Multivariate Analysis and Data Mining}, 243-259.

            Chen, V. and Zhang, H. (2022). Depth importance in 
            precision medicine (DIPM): A tree-and forest-based 
            method for right-censored survival outcomes. 
            \emph{Biostatistics} \strong{23}(1), 157-172.
            
            Seibold, H., Zeileis, A., and Hothorn, T. (2019). 
            model4you: An R package for personalised treatment 
            effect estimation. \emph{Journal of Open Research 
            Software} \strong{7}(1).
            
            Hothorn, T. and Zeileis, A. (2015). partykit: 
            a modular toolkit for recursive partytioning in R. 
            \emph{The Journal of Machine Learning Research} 
            \strong{16}(1), 3905-3909.
}
\seealso{
\code{\link{dipm}}, \code{\link{spmtree}}
}
