% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_of.R
\name{first_of_isoweek}
\alias{first_of_isoweek}
\alias{first_of_isoweek.default}
\alias{last_of_isoweek}
\alias{last_of_isoweek.default}
\alias{first_of_yw}
\alias{last_of_yw}
\title{Get First / Last Day of an Isoweek}
\usage{
first_of_isoweek(x)

\method{first_of_isoweek}{default}(x)

last_of_isoweek(x)

\method{last_of_isoweek}{default}(x)

first_of_yw(x, w = NULL)

last_of_yw(x, w = NULL)
}
\arguments{
\item{x}{Anything that can be coerced to a date with \code{\link[base:as.Date]{base::as.Date()}}}

\item{w}{Two integer (vectors). \code{w} is optional and the interpretation of
\code{x} will depend on whether \code{w} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_yw]{as_date_yw()}}
(e.g. \code{x = 201604} means 4th isoweek of 2016)
\item if \code{x} and \code{w} are supplied, \code{x} is interpreted as year and \code{w} as
week.
}}
}
\value{
a \link{Date}
}
\description{
\code{first_of_yw()} is equivalent with \code{first_of_isoweek()} and only included
for symmetry with \code{\link[=first_of_yq]{first_of_yq()}} and \code{\link[=first_of_ym]{first_of_ym()}}.
}
\examples{
first_of_isoweek("2016-06-04")
last_of_isoweek("2016-06-04")
first_of_yw(2016)
first_of_yw(2016)
}
\seealso{
\code{\link[=first_of_isoweek]{first_of_isoweek()}}
}
