% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_yw.R
\name{date_yw}
\alias{date_yw}
\alias{is_date_yw}
\alias{as_date_yw}
\title{A Simple S3-Class for Year-Isoweek Dates}
\usage{
date_yw(y, w)

is_date_yw(x)

as_date_yw(x)
}
\arguments{
\item{y}{year}

\item{w}{week (optional)}

\item{x}{any R object}
}
\value{
\code{date_yw} returns an object of type \code{date_yw}

\code{is_date_yw} returns \code{TRUE} or \code{FALSE} depending on whether its
argument is of type \code{date_yw} or not.

\code{as_date_yw} attempts to coerce its argument to \code{date_yw}
}
\description{
A simple data type for storing year-isoweek dates in a human readable integer
format, e.g.: the 52nd isoweek of 2012 is stored as 201252. Supports simple
arithmetic operations such as \code{+} and \code{-} as well formatting.
}
\examples{
date_yw(2013, 12)

as_date_yw(201612)

}
\seealso{
\code{\link[=format.date_yw]{format.date_yw()}}, \code{\link[=seq.date_yw]{seq.date_yw()}}, \code{\link[=date_xx_arithmetic]{date_xx_arithmetic()}}

Other date_xx subclasses: \code{\link{date_ym}},
  \code{\link{date_yq}}
}
\concept{date_xx subclasses}
