% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_yw}
\alias{format_yw}
\title{Coerce and Format to Year-Isoweek Strings}
\usage{
format_yw(x, w = NULL, format = "\%Y-W\%W")
}
\arguments{
\item{x, w}{Two integer (vectors). \code{w} is optional and the interpretation of
\code{x} will depend on whether \code{w} is supplied or not:
\itemize{
\item if only \code{x} is supplied, \code{x} will be passed to \code{\link[=as_date_yw]{as_date_yw()}}
(e.g. \code{x = 201604} means 4th isoweek of 2016)
\item if \code{x} and \code{w} are supplied, \code{x} is interpreted as year and \code{w} as
week.
}}

\item{format}{A format that uses a subset of the same placeholders as
\code{\link[base:strptime]{base::strptime()}}:
\tabular{rl}{
\code{\%Y} \tab Year with century (the full year)\cr
\code{\%y} \tab Year without century (the last two digits of the year)\cr
\code{\%m} \tab Month as a decimal numbers (01-12)\cr
\code{\%B} \tab Full month name\cr
\code{\%b} \tab Abbreviated month name
}
Not all placeholders are supported for all \code{date_xx} subclasses.
Literal \% can be escaped with \code{"\%\%"} (as in \code{\link[base:sprintf]{base::sprintf()}}).}
}
\value{
a \code{character} vector
}
\description{
Coerce and Format to Year-Isoweek Strings
}
\section{Formatting shorthands}{


Format shorthand functions in the form of \code{format_y*_[preset]()} directly
apply formatting presets to anything  that can be coerced to a \code{date_xx}.
This is notably handy as they can be used as a labelling function for
\strong{ggplot2}  axes (see \code{vignette("dint")})
}

\examples{
format_yw(2015, 5)
format_yw(201505, format = "\%Y.\%W")
format_yw(as_date_yw(201505), format = "\%y.\%W")

}
\seealso{
\code{\link[=format.date_yw]{format.date_yw()}}

Other coerce and format functions: \code{\link{format_ym}},
  \code{\link{format_yq}}
}
\concept{coerce and format functions}
