#' @export
#' @rdname getters
#' @examples
#' x <- date_yq(2016, 2)
#' get_month(x)
#' \dontrun{
#' library(lubridate)
#' month(x)
#' }
get_month <- function(x){
  UseMethod("get_month")
}




#' @export
get_month.default <- function(x){
  as.POSIXlt(x, tz = tz(x))$mon + 1L
}




#' @export
get_month.date_y <- function(x){
  stop("Not supported for date_y objects")
}




#' @export
get_month.date_ym <- function(x){
  as.integer(as.integer(x) %% 100)
}




#' @export
get_month.date_yq <- function(x){
  c(1L, 4L, 7L, 10L)[get_quarter(x)]
}




#' @inheritParams lubridate::month
#' @rdname year
#'
#'
#' @examples
#'
#' \dontrun{
#'   library(lubridate)
#'   month(x)
#'   month(x, label = TRUE)
#' }
month.date_xx <- function(
  x,
  label = FALSE,
  abbr = TRUE,
  locale = Sys.getlocale("LC_TIME")
){
  assert_lubridate()
  lubridate::month(get_month(x), label = label, abbr = abbr, locale = locale)
}
