% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_coordinates}
\alias{plot_coordinates}
\alias{plot_rows}
\alias{plot_rows-method}
\alias{plot_columns}
\alias{plot_columns-method}
\alias{plot_individuals}
\alias{plot_individuals-method}
\alias{plot_variables}
\alias{plot_variables-method}
\alias{plot_rows,MultivariateAnalysis-method}
\alias{plot_columns,MultivariateAnalysis-method}
\alias{plot_columns,BootstrapPCA-method}
\alias{plot_individuals,PCA-method}
\alias{plot_variables,PCA-method}
\title{Visualize Factor Map}
\usage{
plot_rows(object, ...)

plot_columns(object, ...)

plot_individuals(object, ...)

plot_variables(object, ...)

\S4method{plot_rows}{MultivariateAnalysis}(
  object,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  alpha = NULL,
  colour = NULL,
  fill = NULL,
  shape = NULL,
  size = NULL,
  group = NULL
)

\S4method{plot_columns}{MultivariateAnalysis}(
  object,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  alpha = NULL,
  colour = NULL,
  fill = NULL,
  shape = NULL,
  size = NULL,
  group = NULL
)

\S4method{plot_columns}{BootstrapPCA}(
  object,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  alpha = NULL,
  colour = NULL,
  fill = NULL,
  shape = NULL,
  size = NULL,
  group = NULL
)

\S4method{plot_individuals}{PCA}(
  object,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  alpha = NULL,
  colour = NULL,
  fill = NULL,
  shape = NULL,
  size = NULL,
  group = NULL
)

\S4method{plot_variables}{PCA}(
  object,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  alpha = NULL,
  colour = NULL,
  linetype = NULL,
  size = NULL,
  group = NULL
)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
plotted?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
plotted?}

\item{alpha, colour, fill, linetype, shape, size}{A \code{\link{character}} string
specifying the information to be highlighted (will be mapped to the
corresponding aesthetic).
It must be one of "\code{observation}", "\code{mass}", "\code{sum}", "\code{contribution}",
"\code{cos2}" or "\code{group}" (see details). Any unambiguous substring can be given.
If \code{NULL} (the default), no highlighting is applied.}

\item{group}{A vector of categories specifying the categorical variable from
which to highlight the individuals (only used if at least one of \code{colour},
\code{fill}, \code{linetype} or \code{shape} is set to \code{group}; see details).}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots principal coordinates.
}
\details{
\describe{
\item{\code{observation}}{Whether an observation is active or supplementary.}
\item{\code{mass}}{Weight/mass of each observation.}
\item{\code{sum}}{Sum of squared coordinates along \code{axes}.}
\item{\code{contribution}}{Joint contributions to the definition of \code{axes}.}
\item{\code{cos2}}{Joint \eqn{cos^2}{cos2} along \code{axes}.}
}
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
Y <- pca(iris, scale = TRUE)

## Plot results
plot_individuals(Y, colour = "group", shape = "group", group = iris$Species) +
  khroma::scale_colour_highcontrast()

plot_individuals(Y, colour = "group", size = "cos2", group = iris$Sepal.Width) +
  khroma::scale_color_YlOrBr()

plot_individuals(Y, colour = "contribution", size = "contribution") +
  khroma::scale_color_iridescent(range = c(0.5, 1))

plot_variables(Y, colour = "contribution") +
  ggrepel::geom_label_repel() +
  khroma::scale_color_YlOrBr(range = c(0.5, 1))
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{envelopes}},
\code{\link{plot_contributions}()},
\code{\link{plot_eigenvalues}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
