% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/viz_coordinates.R
\docType{methods}
\name{viz_variables}
\alias{viz_variables}
\alias{viz_variables-method}
\alias{viz_columns}
\alias{viz_columns-method}
\alias{viz_columns,MultivariateAnalysis-method}
\alias{viz_columns,MultivariateBootstrap-method}
\alias{viz_variables,PCA-method}
\alias{viz_variables,CA-method}
\alias{viz_variables,BootstrapPCA-method}
\title{Visualize Variables Factor Map}
\usage{
viz_variables(x, ...)

viz_columns(x, ...)

\S4method{viz_columns}{MultivariateAnalysis}(
  x,
  ...,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  labels = FALSE,
  extra_quali = NULL,
  extra_quanti = NULL,
  color = NULL,
  fill = FALSE,
  symbol = FALSE,
  size = c(1, 6),
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "topleft")
)

\S4method{viz_columns}{MultivariateBootstrap}(
  x,
  ...,
  axes = c(1, 2),
  color = FALSE,
  fill = FALSE,
  symbol = FALSE,
  legend = NULL
)

\S4method{viz_variables}{PCA}(
  x,
  ...,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  labels = list(filter = "contribution", n = 10),
  extra_quali = NULL,
  extra_quanti = NULL,
  color = NULL,
  symbol = NULL,
  size = 1,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "topleft")
)

\S4method{viz_variables}{CA}(
  x,
  ...,
  axes = c(1, 2),
  active = TRUE,
  sup = TRUE,
  labels = FALSE,
  extra_quali = NULL,
  extra_quanti = NULL,
  color = NULL,
  fill = FALSE,
  symbol = FALSE,
  size = c(1, 6),
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  sub = NULL,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "topleft")
)

\S4method{viz_variables}{BootstrapPCA}(
  x,
  ...,
  axes = c(1, 2),
  color = FALSE,
  fill = FALSE,
  symbol = FALSE,
  legend = NULL
)
}
\arguments{
\item{x}{A \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{axes}{A length-two \code{\link{numeric}} vector giving the dimensions to be
plotted.}

\item{active}{A \code{\link{logical}} scalar: should the active observations be
plotted?}

\item{sup}{A \code{\link{logical}} scalar: should the supplementary observations be
plotted?}

\item{labels}{A \code{\link{logical}} scalar: should labels be drawn? Labeling a large
number of points can be computationally expensive and make the graph
difficult to read. A selection of points to label can be provided using a
\code{list} of two named elements, \code{filter} (a string specifying how to filter
the labels to be drawn) and \code{n} (an integer specifying the number of labels
to be drawn). See examples below.}

\item{extra_quali}{An optional vector of qualitative data for aesthetics
mapping.}

\item{extra_quanti}{An optional vector of quantitative data for aesthetics
mapping. If a single \code{\link{character}} string is passed, it must be one of
"\code{observation}", "\code{mass}", "\code{sum}", "\code{contribution}" or "\code{cos2}"
(see \code{\link[=augment]{augment()}}).}

\item{color}{The colors for lines and points (will be mapped to
\code{extra_quanti} or \code{extra_quali}; if both are set, the latter has priority).
Ignored if set to \code{FALSE}. If \code{NULL}, the default color scheme will be used.}

\item{fill}{The background colors for points (will be mapped to
\code{extra_quanti} or \code{extra_quali}; if both are set, the latter has priority).
Ignored if set to \code{FALSE}.}

\item{symbol}{A vector of plotting characters or symbols (will be mapped to
\code{extra_quali}). This can either be a single character or an integer code for
one of a set of graphics symbols. If \code{symbol} is a named a named vector,
then the symbols will be associated with their name within \code{extra_quali}.
Ignored if set to \code{FALSE}.}

\item{size}{A length-two \code{\link{numeric}} vector giving range of possible sizes
(greater than 0; will be mapped to \code{extra_quanti}).
Ignored if set to \code{FALSE}.}

\item{xlim}{A length-two \code{\link{numeric}} vector giving the x limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{ylim}{A length-two \code{\link{numeric}} vector giving the y limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{panel.first}{An \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\value{
\verb{viz_*()} is called for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Plots column/variable principal coordinates.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_quali = "Species")

## Plot individuals
viz_individuals(X, panel.last = graphics::grid())

## Labels of the 10 individuals with highest cos2
viz_individuals(X, labels = list(how = "cos2", n = 10))

## Plot variables
viz_variables(X, panel.last = graphics::grid())

## Graphical parameters
## Continuous values
viz_individuals(X, extra_quanti = iris$Petal.Length, symbol = 16, size = c(1, 2))
viz_individuals(X, extra_quanti = iris$Petal.Length, symbol = 16, size = c(1, 2),
                color = grDevices::hcl.colors(12, "RdPu"))

viz_variables(X, extra_quanti = "contribution",
              color = grDevices::hcl.colors(12, "BluGrn", rev = TRUE),
              size = c(0, 1))

## Discrete values
viz_individuals(X, extra_quali = iris$Species, symbol = 21:23)
viz_individuals(X, extra_quali = iris$Species, symbol = 21:23,
                fill = c("#004488", "#DDAA33", "#BB5566"),
                color = "black")

viz_variables(X, extra_quali = c("Petal", "Petal", "Sepal", "Sepal"),
              color = c("#EE7733", "#0077BB"),
              symbol = c(1, 3))
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{plot}()},
\code{\link{screeplot}()},
\code{\link{viz_contributions}()},
\code{\link{viz_ellipses}()},
\code{\link{viz_individuals}()},
\code{\link{wrap}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
