% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/screeplot.R
\docType{methods}
\name{screeplot}
\alias{screeplot}
\alias{screeplot-method}
\alias{screeplot,MultivariateAnalysis-method}
\alias{screeplot,PCOA-method}
\title{Scree Plot}
\usage{
\S4method{screeplot}{MultivariateAnalysis}(
  x,
  ...,
  eigenvalues = FALSE,
  cumulative = FALSE,
  labels = TRUE,
  limit = 10,
  col = "grey90",
  border = "grey10",
  col.cumulative = "red",
  lty.cumulative = "solid",
  lwd.cumulative = 2
)

\S4method{screeplot}{PCOA}(
  x,
  ...,
  labels = FALSE,
  limit = NULL,
  col = "grey90",
  border = "grey10"
)
}
\arguments{
\item{x}{A \code{\linkS4class{CA}}, \code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Extra parameters to be passed to \code{\link[graphics:barplot]{graphics::barplot()}}.}

\item{eigenvalues}{A \code{\link{logical}} scalar: should the eigenvalues be plotted
instead of variance/inertia?}

\item{cumulative}{A \code{\link{logical}} scalar: should the cumulative percentages of
variance be plotted?}

\item{labels}{A \code{\link{logical}} scalar: should text labels be drawn on top of
bars?}

\item{limit}{An \code{\link{integer}} specifying the number of top elements to be
displayed.}

\item{col, border}{A \code{\link{character}} string specifying the bars infilling and
border colors.}

\item{col.cumulative}{A specification for the line color.}

\item{lty.cumulative}{A specification for the line type.}

\item{lwd.cumulative}{A specification for the line width.}
}
\value{
\code{screeplot()} is called for its side-effects: it results in a graphic
being displayed. Invisibly returns \code{x}.
}
\description{
Plot eigenvalues (scree plot) or variances histogram.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_quali = "Species")

## Screeplot
screeplot(X)
screeplot(X, cumulative = TRUE)
}
\seealso{
Other plot methods: 
\code{\link{biplot}()},
\code{\link{plot}()},
\code{\link{viz_contributions}()},
\code{\link{viz_ellipses}()},
\code{\link{viz_individuals}()},
\code{\link{viz_variables}()},
\code{\link{wrap}}
}
\author{
N. Frerebeau
}
\concept{plot methods}
