% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{loadDeconvData}
\alias{loadDeconvData}
\alias{loadDeconvData,DigitalDLSorter,character-method}
\alias{loadDeconvData,DigitalDLSorter,SummarizedExperiment-method}
\title{Load data to be deconvoluted into a DigitalDLSorter object}
\usage{
loadDeconvData(object, data, name.data = NULL)

\S4method{loadDeconvData}{DigitalDLSorter,character}(object, data, name.data = NULL)

\S4method{loadDeconvData}{DigitalDLSorter,SummarizedExperiment}(object, data, name.data = NULL)
}
\arguments{
\item{object}{\code{\linkS4class{DigitalDLSorter}} object with
\code{trained.model} slot.}

\item{data}{File path where the data is stored or a
\code{SummarizedExperiment} object.}

\item{name.data}{Name under which the data is stored in the
\code{\linkS4class{DigitalDLSorter}} object. When \code{data} is a file
path and \code{name.data} is not provided, the base name of file will be
used.}
}
\value{
A \code{\linkS4class{DigitalDLSorter}} object with \code{deconv.data}
slot with the new bulk-RNA-Seq samples loaded.
}
\description{
Load data to be deconvoluted. Data can be provided from a file path of a
tabulated text file (tsv and tsv.gz formats are accepted) or a
\code{SummarizedExperiment} object.
}
\seealso{
\code{\link{trainDDLSModel}}
\code{\link{deconvDDLSObj}}
}
