% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{calculateEvalMetrics}
\alias{calculateEvalMetrics}
\title{Calculate evaluation metrics for bulk RNA-Seq samples from test data}
\usage{
calculateEvalMetrics(object, metrics = c("MAE", "MSE"))
}
\arguments{
\item{object}{\code{\linkS4class{DigitalDLSorter}} object with a trained
model in the \code{trained.model} slot and the actual cell proportions of
pseudo-bulk samples in \code{prob.cell.matrix} slot.}

\item{metrics}{Metrics used to evaluate the model performance. Mean absolute
error (\code{"MAE"}) and mean squared error (\code{"MSE"}) by default.}
}
\value{
A \code{\linkS4class{DigitalDLSorter}} object with the
\code{trained.model} slot containing a
\code{\linkS4class{DigitalDLSorterDNN}} object with the
\code{test.deconv.metrics} slot. The last contains the metrics calculated.
}
\description{
Calculate evaluation metrics for bulk RNA-seq samples from test data to
understand model performance. By default, absolute error (\code{AbsErr}),
proportional absolute error (\code{ppAbsErr}), squared error (\code{SqrErr})
and proportional squared error (\code{ppSqrErr}) are calculated for each test
sample. In addition, each of these metrics is aggregated using their mean
values according to three criteria: each cell type (\code{CellType}),
probability bins in ranges of 0.1 (\code{pBin}) and number of different cell
types present in the sample \code{nCellTypes}. Finally, the process is
repeated only considering bulk samples (filtering out single-cell profiles
from the evaluation). The evaluation metrics will be available in the
\code{test.deconv.metrics} slot of the
\code{\linkS4class{DigitalDLSorterDNN}} object (\code{trained.model} slot of
the \code{\linkS4class{DigitalDLSorter}} object).
}
\examples{
\dontrun{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
DDLS <- createDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE, 
  sc.log.FC = FALSE
)
probMatrixValid <- data.frame(
  Cell_Type = paste0("CellType", seq(6)),
  from = c(1, 1, 1, 15, 15, 30),
  to = c(15, 15, 30, 50, 50, 70)
)
DDLS <- generateBulkCellMatrix(
  object = DDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  prob.design = probMatrixValid,
  num.bulk.samples = 50,
  verbose = TRUE
)
# training of DDLS model
tensorflow::tf$compat$v1$disable_eager_execution()
DDLS <- trainDDLSModel(
  object = DDLS,
  on.the.fly = TRUE,
  batch.size = 15,
  num.epochs = 5
)
# evaluation using test data
DDLS <- calculateEvalMetrics(
  object = DDLS
)
}

}
\seealso{
\code{\link{distErrorPlot}} \code{\link{corrExpPredPlot}}
\code{\link{blandAltmanLehPlot}} \code{\link{barErrorPlot}}
}
