% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summmary.R
\docType{methods}
\name{summary,Diff-method}
\alias{summary,Diff-method}
\title{Summary Method for Diff Objects}
\usage{
\S4method{summary}{Diff}(object, scale.threshold = 0.1, max.lines = 50L,
  width = getOption("width"), ...)
}
\arguments{
\item{object}{at \code{Diff} object}

\item{scale.threshold}{numeric(1L) between 0 and 1, how much distortion to
allow when creating the summary map, where 0 is none and 1 is as much as
needed to fit under \code{max.lines}, defaults to 0.1}

\item{max.lines}{integer(1L) how many lines to allow for the summary map,
defaults to 50}

\item{width}{integer(1L) how many columns wide the output should be, defaults
to \code{getOption("width")}}

\item{...}{unused, for compatibility with generic}
}
\value{
a \code{DiffSummary} object
## `pager="off"` for CRAN compliance; you may omit in normal use
summary(diffChr(letters, letters[-c(5, 15)], format="raw", pager="off"))
}
\description{
Provides high level count of insertions, deletions, and matches, as well as a
\dQuote{map} of where the differences are.
}
\details{
Sequences of single operations (e.g. "DDDDD") are compressed provided that
compressing them does not distort the relative size of the sequence relative
to the longest such sequence in the map by more than \code{scale.threshold}.
Since length 1 sequences cannot be further compressed \code{scale.threshold}
does not apply to them.
}
