% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensus_evaluate.R
\name{compactness}
\alias{compactness}
\title{Compactness Measure}
\usage{
compactness(data, labels)
}
\arguments{
\item{data}{a dataset with rows as observations, columns as variables}

\item{labels}{a vector of cluster labels from a clustering result}
}
\value{
the compactness score
}
\description{
Compute the compactness validity index for a clustering result.
}
\details{
This index is agnostic to any reference clustering results, calculating
cluster performance on the basis of compactness and separability. Smaller
values indicate a better clustering structure.
}
\examples{
set.seed(1)
E <- matrix(rep(sample(1:4, 1000, replace = TRUE)), nrow = 100, byrow =
              FALSE)
set.seed(1)
dat <- as.data.frame(matrix(runif(1000, -10, 10), nrow = 100, byrow = FALSE))
compactness(dat, E[, 1])
}
\references{
MATLAB function \code{valid_compactness} by Simon Garrett in
LinkCluE
}
\author{
Derek Chiu
}
