% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Chicago}
\alias{Chicago}
\alias{stations}
\title{Chicago Ridership Data}
\source{
Kuhn and Johnson (2020), \emph{Feature Engineering and Selection},
Chapman and Hall/CRC . \url{https://bookdown.org/max/FES/} and
\url{https://github.com/topepo/FES}
}
\value{
\item{Chicago}{a tibble} \item{stations}{a vector of station names}
}
\description{
Chicago Ridership Data
}
\details{
These data are from Kuhn and Johnson (2020) and contain an
\emph{abbreviated} training set for modeling the number of people (in thousands)
who enter the Clark and Lake L station.

The \code{date} column corresponds to the current date. The columns with station
names (\code{Austin} through \code{California}) are a \emph{sample} of the columns used in
the original analysis (for file size reasons). These are 14 day lag
variables (i.e. \code{date - 14 days}). There are columns related to weather and
sports team schedules.

The station at 35th and Archer is contained in the column \code{Archer_35th} to
make it a valid R column name.
}
\examples{
data(Chicago)
str(Chicago)
stations
}
\keyword{datasets}
