% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\docType{data}
\name{weight}
\alias{weight}
\alias{text_parameters}
\alias{weight_scheme}
\alias{token}
\alias{max_times}
\alias{min_times}
\alias{max_tokens}
\title{Parameter objects related to text analysis.}
\format{An object of class \code{quant_param} (inherits from \code{param}) of length 7.}
\usage{
weight

weight_scheme

token

max_times

min_times

max_tokens
}
\value{
Each object is generated by either \code{new_quant_param} or
\code{new_qual_param}.
}
\description{
These are objects that can be used for modeling, especially in conjunction
with the \pkg{textrecipes} package.
}
\details{
These objects are pre-made parameter sets that are useful in a variety of
models.
\itemize{
\item \code{min_times}, \code{max_times}: frequency of word occurances for removal.
See \code{?step_tokenfilter}.
\item \code{max_tokens}: the number of tokens that will be retained. See
\code{?step_tokenfilter}.
\item \code{weight}: A parameter for "double normalization" when creating token
counts. See \code{?step_tf}.
\item \code{weight_scheme}: the method for  term frequency calculations. Possible
values are: "binary", "raw count", "term frequency", "log normalization",
or "double normalization". See \code{?step_tf}.
\item \code{token}: the type of token with possible values: "characters",
"character_shingle", "lines", "ngrams", "paragraphs", "ptb", "regex",
"sentences", "skip_ngrams", "tweets", "words", "word_stems". See
\code{?step_tokenize}
}
}
\keyword{datasets}
