% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_kernel.R
\name{rbf_sigma}
\alias{rbf_sigma}
\alias{scale_factor}
\alias{kernel_offset}
\title{Kernel parameters}
\usage{
rbf_sigma(range = c(-10, 0), trans = log10_trans())

scale_factor(range = c(-10, -1), trans = log10_trans())

kernel_offset(range = c(0, 2), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Parameters related to the radial basis or other kernel functions.
}
\details{
\code{degree()} can also be used in kernel functions.
}
\examples{
rbf_sigma()
scale_factor()
kernel_offset()
}
