% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{new_quant_param}
\alias{new_quant_param}
\alias{new_qual_param}
\title{Tools for creating new parameter objects}
\usage{
new_quant_param(type = c("double", "integer"), range, inclusive,
  default = unknown(), trans = NULL, values = NULL, label = NULL)

new_qual_param(type = c("character", "logical"), values,
  default = unknown(), label = NULL)
}
\arguments{
\item{type}{A single character value. For quantitative parameters, valid
choices are "double" and "integer" while for qualitative factors they are
"character" and "logical".}

\item{range}{A two-element list of vector with the lowest or largest possible
values, respectively. If these cannot be set when the parameter is defined,
the \code{unknown()} function can be used. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{inclusive}{A two-element logical vector for whether the the range
values should be inclusive or exclusive.}

\item{default}{A single value the same class as \code{type} for the default
parameter value. \code{unknown()} can also be used here.}

\item{trans}{A \code{trans} object from the \pkg{scales} package, such as
\code{\link[scales:log10_trans]{scales::log10_trans()}} or \code{\link[scales:reciprocal_trans]{scales::reciprocal_trans()}}.}

\item{values}{A vector of possible values that is required when \code{type} is
"character" or "logical" but optional otherwise.}

\item{label}{An optional named character string that can be used for
printing and plotting. The named should reflect the object name (e.g.
"mtry", "neighbors", etc.)}
}
\value{
An object of class "param" with the primary class being either
"quant_param" or "qual_param". The \code{range} element of the object is always
converted to a list with elements "lower" and "upper". '
}
\description{
These functions are used to construct new parameter objects.
}
\examples{
num_subgroups <-
  new_quant_param(
    type = "integer",
    range = c(1L, 20L),
    inclusive = c(TRUE, TRUE),
    trans = NULL,
    label = c(num_subgroups = "# Subgroups")
  )
}
