% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{class}
\name{scen-class}
\alias{scen-class}
\title{An S4 class to represent a simulated scenarios.}
\description{
An S4 class to represent a simulated scenarios.
}
\section{Slots}{

\describe{
\item{\code{PKparameters}}{Subject's pharmacokinetic's (PK) parameters from the population distributions defined by the population mean.}

\item{\code{nPK}}{The length of the time points.}

\item{\code{time}}{The sampling time points.}

\item{\code{idtr}}{The id number of the corresponding simulated dataset.}

\item{\code{N}}{The total sample size per trial.}

\item{\code{doses}}{A vector with the doses panel.}

\item{\code{preal}}{The prior toxicity probabilities.}

\item{\code{limitTox}}{The toxicity threshold.}

\item{\code{omegaIIV}}{The inter-individual variability for the clearance and the volume of distribution.}

\item{\code{omegaAlpha}}{The patient's sensitivity parameter.}

\item{\code{conc}}{The concentration computed at the PK population values.}

\item{\code{concPred}}{The concentration values with proportional errors for each patient at each dose.}

\item{\code{tox}}{The toxicity outcome.}

\item{\code{tab}}{A summary matrix containing the sampling time points at the first row followed by concPred, parameters and alphaAUC. It used by the simulation function nsim.}

\item{\code{parameters}}{The simulated PK parameters of each patient.}

\item{\code{alphaAUC}}{A vector with the computed AUC values of each patient.}
}}

