% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_clean_sql.R
\name{get_clean_sql}
\alias{get_clean_sql}
\title{Get a cleaned SQL script into R}
\usage{
get_clean_sql(filepath, additional_settings = FALSE)
}
\arguments{
\item{filepath}{path to a SQL script}

\item{additional_settings}{TRUE or FALSE boolean for the addition of
settings at the start of the SQL script}
}
\value{
Cleaned string containing SQL query
}
\description{
This function cleans a SQL script, ready for using within R in the DfE.
}
\examples{
# This assumes you have already set up a database connection
# and that the filepath for the function exists
# For more details see the vignette on connecting to SQL

# Pull a cleaned version of the SQL file into R
if (file.exists("your_script.sql")) {
  sql_query <- get_clean_sql("your_script.sql")
}
}
