% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{mst_rules}
\alias{mst_rules}
\title{Define routing rules}
\usage{
mst_rules(...)
}
\arguments{
\item{...}{routing rules defined using a a dot-like syntax, read --+ as an arrow and [:] as a range of score to move to the next stage}
}
\value{
data.frame with columns...
}
\description{
Define routing rules for use in \code{\link{create_mst_test}}
}
\details{
Each scoring rule in `...` defines one or more routing rules together making up a booklet.
For example, `route1 = a[0:5] --+ d[9:15] --+ f` means a start at module `a`, continue to module `d` when the score on 
`a` is between 0 and 5 (inclusive) and continue to `g` when the score on modules `a + b` is between 0 and 8 (for `All` routing)
or the score on just module 'b' is between 0 and 8 (for `Last` routing).
`route1` becomes the id of the specific path or booklet, which must be supplied with the data later.

A routing design for a linear (non-multistage) booklet can simply be entered as \code{mst_rules(my_booklet = my_single_module)}.
}
\examples{
# a (complicated) three stage (1-3-3) routing design with 9 booklets and 7 modules

routing_rules = mst_rules(bk1 = M1[0:61] --+ M2[0:136]   --+ M5,
                          bk2 = M1[0:61] --+ M2[137:183] --+ M6,
                          bk3 = M1[0:61] --+ M2[184:Inf] --+ M7,

                          bk4 = M1[62:86] --+ M3[0:98]    --+ M5,
                          bk5 = M1[62:86] --+ M3[99:149]  --+ M6,
                          bk6 = M1[62:86] --+ M3[150:Inf] --+ M7,

                          bk7 = M1[87:Inf] --+ M4[0:98]    --+ M5,
                          bk8 = M1[87:Inf] --+ M4[99:130]  --+ M6,
                          bk9 = M1[87:Inf] --+ M4[131:Inf] --+ M7)
      
}
\seealso{
\code{\link{create_mst_test}} for a description of all and last routing and \code{\link{add_response_data_mst}} to see how to enter data
}
