% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_l.R
\name{best_l}
\alias{best_l}
\title{Find the best length parameter for boxcar detrending.}
\usage{
best_l(img, seed = NULL, parallel = FALSE)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{seed}{Random numbers may be generated during the detrending process.
For reproducibility, you can set a seed for this random number generation
here.}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\value{
If no detrend is necessary, this function returns \code{NA}. If a detrend
is required, this function returns a natural number which is the ideal
length parameter for boxcar detrending. If there are multiple channels, the
function returns a vector, one \code{l} parameter for each channel.
}
\description{
Use Nolan's algorithm to find the ideal length parameter for boxcar
detrending. Boxcar detrending is also referred to as 'running average'.
}
\examples{
## These examples are not run on CRAN because they take too long.
## You should still try them for yourself.
img <- ijtiff::read_tif(system.file('extdata', 'bleached.tif',
                                    package = 'detrendr'))
best_l(img, seed = 0, parallel = 2)

}
\references{
Rory Nolan, Luis A. J. Alvarez, Jonathan Elegheert, Maro
Iliopoulou, G. Maria Jakobsdottir, Marina Rodriguez-Muñoz, A. Radu
Aricescu, Sergi Padilla-Parra; nandb—number and brightness in R with a
novel automatic detrending algorithm, Bioinformatics,
https://doi.org/10.1093/bioinformatics/btx434.
}
