% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funktionen.R
\name{createRUNdf}
\alias{createRUNdf}
\title{Function to create a dataframe of RUNS per individual animal
Requires a map file (other filename to read or R object)
Parameters on maximum number of missing and opposite genotypes in the run (not the window) are implemented here}
\usage{
createRUNdf(snpRun, mapFile, minSNP = 3, minLengthBps = 1000,
  minDensity = 1/10, oppositeAndMissingSNP, maxOppRun = NULL,
  maxMissRun = NULL)
}
\arguments{
\item{snpRun}{vector of TRUE/FALSE (is the SNP in a RUN?)}

\item{mapFile}{Plink-like map file (data.frame)}

\item{minSNP}{minimum n. of SNP to call a RUN}

\item{minLengthBps}{minimum length of run in bps (defaults to 1000 bps = 1 kbps)}

\item{minDensity}{minimum n. of SNP per kbps (defaults to 0.1 = 1 SNP every 10 kbps)}

\item{oppositeAndMissingSNP}{indexed array of missing and opposite genotypes (SNP order in the genome is the index)}

\item{maxOppRun}{max n. of opposite genotype SNPs in the run (not in the window!)}

\item{maxMissRun}{max n. of missing SNPs in the run (not in the window!)}
}
\value{
a data.frame with RUNS per animal
}
\description{
Function to create a dataframe of RUNS per individual animal
Requires a map file (other filename to read or R object)
Parameters on maximum number of missing and opposite genotypes in the run (not the window) are implemented here
}
