% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create}
\alias{create}
\title{Create a Dependencies JSON File}
\usage{
create(
  dir = getwd(),
  file = "dependencies.json",
  output = dir,
  platform = NULL,
  installed = c("base", "recommended"),
  overwrite = TRUE,
  ask = TRUE
)
}
\arguments{
\item{dir}{Path to the directory where the files to be scanned are located.}

\item{file}{The name of the file to be save, default is \code{"dependencies.json"}.}

\item{output}{Path to the directory where JSON file should be written to.}

\item{platform}{The platform supplied to \code{sysreqs()}.
It can be \code{NULL} when the value of the R_DEPS_PLATFORM environment variable is used when set,
defaults to \code{"DEB"} when R_DEPS_PLATFORM is unset.
It can be \code{NA} in which case no system requirements are returned.}

\item{installed}{The \code{priority} argument for \code{installed.packages()} for packages to be excluded.}

\item{overwrite}{Logical, should the \code{file} in the \code{output} directory be overwritten if exists?}

\item{ask}{Logical, asking confirmation before writing the \code{dependencies.json} file.}
}
\value{
Invisibly returns the list of file names that were created. The side effect is a JSON (and possibly a text for system requirements) file written to the hard drive. The function fails when there are no R related files in \code{dir}.
}
\description{
Discover dependencies and write a \code{dependencies.json} file.
}
\examples{
dir <- system.file("examples/01-basic", package = "deps")
out <- tempdir()
create(dir, output = out, ask = interactive())
cat(readLines(file.path(out, "dependencies.json")), sep = "\n")
unlink(file.path(out, "dependencies.json"))

}
