# 
# Ingmar Visser
# 
# LYSTIG algoritme voor de loglikelihood, 23-3-2008
# 

lystig <- function(init,A,B,ntimes=NULL,stationary=TRUE) {

	# Log likelihood computation according to Lystig & Hughes (2002).  This
	# is very similar to the Forward part of the Forward-Backward algorithm
	# but admits of easy computation of the gradients of parameters and the
	# observed information.  This version of the routine only computes the
	# likelihood though.
	
	# NOTE THE CHANGE IN FROM ROW TO COLUMN SUCH THAT TRANSPOSING A IS NOT
	# NECCESSARY ANYMORE 
	
	# K is the number of states of the model
	
	# A = K*K matrix if stationary=TRUE with transition probabilities, from column to row!!!!!
	# A = T*K*K arrary if stationary=FALSE
	
	# B = T*K matrix with elements b_{tj} = P(y_t|s_j)
	# init = K*length(ntimes) matrix with initial probs per case
	# Returns: 'sca'le factors, recurrent variables 'phi', loglikelihood
	
	nt <- nrow(B)
	ns <- ncol(init)
		
	if(!is.null(ntimes)) {
		ntimes <- nt
	}
	
	phi <- matrix(ncol=ns,nrow=nt)
	sca <- vector(length=nt)
	
	lt <- length(ntimes)
	et <- cumsum(ntimes)
	bt <- c(1,et[-lt]+1)
	
	ll <- 0
	
	for(case in 1:lt) { # multiple cases
		phi[bt[case],] <- init[case,]*B[bt[case],] # initialize
		sca[bt[case]] <- 1/sum(phi[bt[case],])
		if(ntimes[case]>1) {
			for(i in (bt[case]+1):et[case]) {
				if(stationary) phi[i,] <- (A[1,,]%*%phi[i-1,])*B[i,]
				else phi[i,] <- (A[i-1,,]%*%phi[i-1,])*B[i,]
				phi[i,] <- sca[i-1]*phi[i,]
				sca[i] <- 1/sum(phi[i,])
			}
		}
	}
	
	logLike=-sum(log(sca))
	
	return(list(phi=phi,sca=sca,logLike=logLike))
	
}

