% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htypes.R
\name{is_hdesc}
\alias{is_hdesc}
\alias{is_single_hdesc}
\title{Checks for describe objects}
\usage{
is_hdesc(x)

is_single_hdesc(x)
}
\arguments{
\item{x}{an object to test if it is of class `describe`.}
}
\value{
(lgl) is `x` (a single element or a general) `describe`
  object?
}
\description{
These two function are useful to test if an object is of class
[Hmisc][Hmisc::describe].
}
\details{
In `Hmisc` both "single" `describe` objects and lists
of them are of class `describe`. In particular, even if
`Hmisc::describe()` results in a single variable description, it is
 directly the "single" `describe` object and not a list of them with
 only a single `describe` object included!

`is_hdesc()` test for general inheritance.

`is_single_hdesc()` test for single instance of a
  `describe` object.
}
\examples{
\donttest{
  library(Hmisc)
  desc <- describe(mtcars)

  is_hdesc(desc) # TRUE
  is_hdesc(desc[[1]]) # TRUE
}
\donttest{
  is_single_hdesc(desc) # FALSE
  is_single_hdesc(desc[[1]]) # TRUE
}
}
\seealso{
[describe][Hmisc::describe]

[is_hcat], [is_hcon], [htype], [htypes]
}
