% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_functions.R
\name{tunedStepSize}
\alias{tunedStepSize}
\title{Get  values of the tuned step sizes.}
\usage{
tunedStepSize(RDobject)
}
\arguments{
\item{RDobject}{A readsData object with a filled output slot.}
}
\value{
A list of the tuned step sizes for sampling each of the parameters.
}
\description{
Extracts the tuned step sizes for sampling each parameter from  the return value of  denoiseq.
}
\examples{
#pre -filtering to remove lowly expressed genes
ERCC <- ERCC[rowSums(ERCC)>0,]
RD <- new('readsData',counts = ERCC)
steps <- 30
#30 steps are just for illustration here. Atleast 5000 steps are adequate.
BI <- denoiseq(RD,steps)
tunedStepSize(BI)

}
