% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendro.resolution.R
\name{dendro.resolution}
\alias{dendro.resolution}
\title{Check the resolution of the data}
\usage{
dendro.resolution(dm.data, unts = c("secs", "mins", "hours", "days"))
}
\arguments{
\item{dm.data}{a \code{data.frame} with a timestamp (\code{\%Y-\%m-\%d \%H:\%M:\%S} format) as row names, and dendrometer series in columns. Output as created using code from the \code{Import dendrometer data} vignette.}

\item{unts}{a \code{character} string of "secs", "mins", "hours", "days", specifiying the units in which the resolution should be calculated. Defaults to \code{"secs"}. Argument matching is performed.}
}
\value{
The function returns the resolution of the data in the desired unit.
}
\description{
The function provides the resolution of the dendrometer data.
}
\examples{
data(dmCD, dmHS, dmED)
dendro.resolution(dmCD, unts = "hours")
dendro.resolution(dmHS, unts = "hours")
dendro.resolution(dmED, unts = "mins")

}
\author{
Marko Smiljanic
}
