% Generated by roxygen2 (4.0.2): do not edit by hand
\name{partition_leaves}
\alias{partition_leaves}
\title{A list with labels for each subtree (edge)}
\source{
A \link{dendrogram} implementation for \link[distory]{partition.leaves} from the {distory} package
}
\usage{
partition_leaves(x, ...)
}
\arguments{
\item{x}{a dendrogram}

\item{...}{Ignored.}
}
\value{
A list with the labels for each of the nodes in the dendrogram.
}
\description{
Returns the set of all bipartitions from all edges, that is: a list with the labels
for each of the nodes in the dendrogram.
}
\examples{
x <- 1:3 \%>\% dist \%>\% hclust \%>\% as.dendrogram
plot(x)
partition_leaves(x)

\dontrun{
set.seed(23235)
ss <- sample(1:150, 10 )
dend1 <- iris[ss,-5] \%>\% dist \%>\% hclust("com") \%>\% as.dendrogram
dend2 <- iris[ss,-5] \%>\% dist \%>\% hclust("single") \%>\% as.dendrogram

partition_leaves(dend1)
partition_leaves(dend2)
}
}
\seealso{
\link{distinct_edges}, \link{highlight_distinct_edges},
\link{dist.dendlist}, \link{tanglegram},
\link[distory]{partition.leaves}
}

