% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lca.R
\name{forecast.lca}
\alias{forecast.lca}
\title{Forecast demogdata data using Lee-Carter method.}
\usage{
\method{forecast}{lca}(object, h = 50, se = c("innovdrift",
  "innovonly"), jumpchoice = c("fit", "actual"), level = 80, ...)
}
\arguments{
\item{object}{Output from \code{\link{lca}}.}

\item{h}{Number of years ahead to forecast.}

\item{se}{Method used for computation of standard error. Possibilities: \dQuote{innovdrift} (innovations and drift) and \dQuote{innovonly} (innovations only).}

\item{jumpchoice}{Method used for computation of jumpchoice. Possibilities: \dQuote{actual} (use actual rates from final year) and \dQuote{fit} (use fitted rates).}

\item{level}{Confidence level for prediction intervals.}

\item{...}{Other arguments.}
}
\value{
Object of class \code{fmforecast} with the following components:
\item{label}{Region from which the data are taken.}
\item{age}{Ages from \code{object}.}
\item{year}{Years from \code{object}.}
\item{rate}{List of matrices containing forecasts, lower bound and upper bound of prediction intervals.
  Point forecast matrix takes the same name as the series that has been forecast.}
\item{fitted}{Matrix of one-step forecasts for historical data}
Other components included are
\item{e0}{Forecasts of life expectancies (including lower and upper bounds)}
\item{kt.f}{Forecasts of coefficients from the model.}
\item{type}{Data type.}
\item{model}{Details about the fitted model}
}
\description{
The kt coefficients are forecast using a random walk with drift.
The forecast coefficients are then multiplied by bx to
obtain a forecast demographic rate curve.
}
\examples{
france.lca <- lca(fr.mort, adjust="e0")
france.fcast <- forecast(france.lca, 50)
plot(france.fcast)
plot(france.fcast,'c')
}
\author{
Rob J Hyndman
}
\keyword{models}
