#' Dates of corals from the South China Sea
#'
#' This data set provides radiocarbon and 230Th dates of corals sampled in the South China Sea. There are five pairs of dates in this data set organized as columns. For more details see Yu et al, 2010.
#' @usage data(coral)
#' @format A data frame containing six columns and four rows. First column indicates a type of dates constituting each of five pairs stored in the other columns. Rows correspond to (in descending order): 230Th date of a coral sample, its standard deviation, radiocarbon date of the same sample and its standard deviation. Column names indicate pair identification codes, which is further used for pair identification.
#' @source Data were published in Yu et al, 2010, table 2.
#' @references Yu K, Hua Q, Zhao J, Hodge E, Fink D, Barbetti M. 2010. Holocene marine 14C reservoir age variability: Evidence from 230Th-dated corals in the South China Sea. Paleoceangraphy. 25: PA3205 <doi:10.1029/2009PA001831>
"coral"
